package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.model.P06B52T00Datatype;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (27/01/2012)
 */
public class P06B52T00DAO {
	
	static private P06B52T00DAO instance = null;

	public static P06B52T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B52T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B52T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B52T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B52T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B52T00DAO-select");
		P06B52T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B52T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B52_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B52_NUMEXP));
			    result.setNetoPropCapEscr(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_CAPESCR)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_CAPESCR));
			    result.setNetoPropCapNoExig(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_CAPNOEXIG)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_CAPNOEXIG));
			    result.setNetoPropPrimEmis(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_PRIMEMIS)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_PRIMEMIS));
			    result.setNetoPropReser(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESER)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESER));
			    result.setNetoPropAccion(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_ACCION)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_ACCION));
			    result.setNetoPropResEjerAnt(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESEJERANT)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESEJERANT));
			    result.setNetoPropOtrasApor(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_OTRASAPOR)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_OTRASAPOR));
			    result.setNetoPropResEjer(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESEJER)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_RESEJER));
			    result.setNetoPropDividen(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_DIVIDEN)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_DIVIDEN));
			    result.setNetoPropOtrosInstr(lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_OTROSINSTR)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_PROP_OTROSINSTR));
			    result.setNetoAjusCam(lrst.getString(P06BTablas.P06B_P06B52_NETO_AJUSCAM)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_AJUSCAM));
			    result.setNetoSubv(lrst.getString(P06BTablas.P06B_P06B52_NETO_SUBV)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NETO_SUBV));
			    result.setNoCorrProv(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_PROV)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_PROV));
			    result.setNoCorrDeudCred(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_CRED)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_CRED));
			    result.setNoCorrDeudArren(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_ARREN)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_ARREN));
			    result.setNoCorrDeudOtras(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_OTRAS)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUD_OTRAS));
			    result.setNoCorrDeudEmp(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUDEMP)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_DEUDEMP));
			    result.setNoCorrImpuesDif(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_IMPUESDIF)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_IMPUESDIF));
			    result.setNoCorrPeriodif(lrst.getString(P06BTablas.P06B_P06B52_NOCORR_PERIODIF)==null?"":lrst.getString(P06BTablas.P06B_P06B52_NOCORR_PERIODIF));
			    result.setCorrNoCorr(lrst.getString(P06BTablas.P06B_P06B52_CORR_NOCORR)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_NOCORR));
			    result.setCorrProv(lrst.getString(P06BTablas.P06B_P06B52_CORR_PROV)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_PROV));
			    result.setCorrDeudCred(lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_CRED)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_CRED));
			    result.setCorrDeudArren(lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_ARREN)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_ARREN));
			    result.setCorrDeudOtras(lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_OTRAS)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUD_OTRAS));
			    result.setCorrDeudEmp(lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUDEMP)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_DEUDEMP));
			    result.setCorrProveed(lrst.getString(P06BTablas.P06B_P06B52_CORR_PROVEED)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_PROVEED));
			    result.setCorrOtrosAcreed(lrst.getString(P06BTablas.P06B_P06B52_CORR_OTROSACREED)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_OTROSACREED));
			    result.setCorrPeriodif(lrst.getString(P06BTablas.P06B_P06B52_CORR_PERIODIF)==null?"":lrst.getString(P06BTablas.P06B_P06B52_CORR_PERIODIF));
	        }
	        P06BLog.send(2,this, "Fin P06B52T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}
	
	
	/**
	    * Obtiene un registro de la BD a partir de la clave primaria
	    * @param tipoMediador.
	    *            parte de la clave primaria
	    * @param ejer.
	    *            parte de la clave primaria
	    * @return un objeto P06B52T00Datatype o null si no se encuentra nada.
		* @throws Exception
	    */
		public P06B52T00Datatype selectTipoMediador(String ejer, String tipoMediador) throws Exception{
			P06BLog.send(2,this, "Inicio P06B52T00DAO-selectTipoMediador");
			P06B52T00Datatype result = null;
			PreparedStatement lstm  = null;
	        ResultSet lrst  = null;
	        String sql = SELECT_BY_PKTIPOMEDIADOR;
	        String tipoMediadorFmtd = tipoMediador.toUpperCase()+"-%";
	        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
	        try {
	        	lstm = lconConexion.prepareStatement(sql);
	        	lstm.setString(1,ejer);
	        	lstm.setString(2,tipoMediadorFmtd);
	        	lrst = lstm.executeQuery();
		        if (lrst.next()) {
		        	result = new P06B52T00Datatype();
		        	
		        	result.setEjercicio(ejer);
		        	result.setNumExp(tipoMediadorFmtd);
				    result.setNetoPropCapEscr(lrst.getString(1)==null?"":lrst.getString(1));
				    result.setNetoPropCapNoExig(lrst.getString(2)==null?"":lrst.getString(2));
				    result.setNetoPropPrimEmis(lrst.getString(3)==null?"":lrst.getString(3));
				    result.setNetoPropReser(lrst.getString(4)==null?"":lrst.getString(4));
				    result.setNetoPropAccion(lrst.getString(5)==null?"":lrst.getString(5));
				    result.setNetoPropResEjerAnt(lrst.getString(6)==null?"":lrst.getString(6));
				    result.setNetoPropOtrasApor(lrst.getString(7)==null?"":lrst.getString(7));
				    result.setNetoPropResEjer(lrst.getString(8)==null?"":lrst.getString(8));
				    result.setNetoPropDividen(lrst.getString(9)==null?"":lrst.getString(9));
				    result.setNetoPropOtrosInstr(lrst.getString(10)==null?"":lrst.getString(10));
				    result.setNetoAjusCam(lrst.getString(11)==null?"":lrst.getString(11));
				    result.setNetoSubv(lrst.getString(12)==null?"":lrst.getString(12));
				    result.setNoCorrProv(lrst.getString(13)==null?"":lrst.getString(13));
				    result.setNoCorrDeudCred(lrst.getString(14)==null?"":lrst.getString(14));
				    result.setNoCorrDeudArren(lrst.getString(15)==null?"":lrst.getString(15));
				    result.setNoCorrDeudOtras(lrst.getString(16)==null?"":lrst.getString(16));
				    result.setNoCorrDeudEmp(lrst.getString(17)==null?"":lrst.getString(17));
				    result.setNoCorrImpuesDif(lrst.getString(18)==null?"":lrst.getString(18));
				    result.setNoCorrPeriodif(lrst.getString(19)==null?"":lrst.getString(19));
				    result.setCorrNoCorr(lrst.getString(20)==null?"":lrst.getString(20));
				    result.setCorrProv(lrst.getString(21)==null?"":lrst.getString(21));
				    result.setCorrDeudCred(lrst.getString(22)==null?"":lrst.getString(22));
				    result.setCorrDeudArren(lrst.getString(23)==null?"":lrst.getString(23));
				    result.setCorrDeudOtras(lrst.getString(24)==null?"":lrst.getString(24));
				    result.setCorrDeudEmp(lrst.getString(25)==null?"":lrst.getString(25));
				    result.setCorrProveed(lrst.getString(26)==null?"":lrst.getString(26));
				    result.setCorrOtrosAcreed(lrst.getString(27)==null?"":lrst.getString(27));
				    result.setCorrPeriodif(lrst.getString(28)==null?"":lrst.getString(28));
		        }
		        P06BLog.send(2,this, "Fin P06B52T00DAO-selectTipoMediador");
		    } catch (SQLException e) {
		    	P06BLog.send(2,this, "error: " +e.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e;
		    }catch (Exception e2) {	 
	        	P06BLog.send(2,this, "error: " +e2.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e2;
		    }finally {
		    	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		    }
			return result;
		}
		
		
		/**
		    * Obtiene un registro de la BD a partir de la clave primaria
		    * @param tipoMediador.
		    *            parte de la clave primaria
		    * @param ejer.
		    *            parte de la clave primaria
		    * @return un objeto P06B52T00Datatype o null si no se encuentra nada.
			* @throws Exception
		    */
			public P06B52T00Datatype selectSumOfEjer(String ejer) throws Exception{
				P06BLog.send(2,this, "Inicio P06B52T00DAO-selectSumOfEjer");
				P06B52T00Datatype result = null;
				PreparedStatement lstm  = null;
		        ResultSet lrst  = null;
		        String sql = SELECTSUM_OFEJER;
		        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
		        try {
		        	lstm = lconConexion.prepareStatement(sql);
		        	lstm.setString(1,ejer);
		        	lrst = lstm.executeQuery();
			        if (lrst.next()) {
			        	result = new P06B52T00Datatype();
			        	
			        	result.setEjercicio(ejer);
					    result.setNetoPropCapEscr(lrst.getString(1)==null?"":lrst.getString(1));
					    result.setNetoPropCapNoExig(lrst.getString(2)==null?"":lrst.getString(2));
					    result.setNetoPropPrimEmis(lrst.getString(3)==null?"":lrst.getString(3));
					    result.setNetoPropReser(lrst.getString(4)==null?"":lrst.getString(4));
					    result.setNetoPropAccion(lrst.getString(5)==null?"":lrst.getString(5));
					    result.setNetoPropResEjerAnt(lrst.getString(6)==null?"":lrst.getString(6));
					    result.setNetoPropOtrasApor(lrst.getString(7)==null?"":lrst.getString(7));
					    result.setNetoPropResEjer(lrst.getString(8)==null?"":lrst.getString(8));
					    result.setNetoPropDividen(lrst.getString(9)==null?"":lrst.getString(9));
					    result.setNetoPropOtrosInstr(lrst.getString(10)==null?"":lrst.getString(10));
					    result.setNetoAjusCam(lrst.getString(11)==null?"":lrst.getString(11));
					    result.setNetoSubv(lrst.getString(12)==null?"":lrst.getString(12));
					    result.setNoCorrProv(lrst.getString(13)==null?"":lrst.getString(13));
					    result.setNoCorrDeudCred(lrst.getString(14)==null?"":lrst.getString(14));
					    result.setNoCorrDeudArren(lrst.getString(15)==null?"":lrst.getString(15));
					    result.setNoCorrDeudOtras(lrst.getString(16)==null?"":lrst.getString(16));
					    result.setNoCorrDeudEmp(lrst.getString(17)==null?"":lrst.getString(17));
					    result.setNoCorrImpuesDif(lrst.getString(18)==null?"":lrst.getString(18));
					    result.setNoCorrPeriodif(lrst.getString(19)==null?"":lrst.getString(19));
					    result.setCorrNoCorr(lrst.getString(20)==null?"":lrst.getString(20));
					    result.setCorrProv(lrst.getString(21)==null?"":lrst.getString(21));
					    result.setCorrDeudCred(lrst.getString(22)==null?"":lrst.getString(22));
					    result.setCorrDeudArren(lrst.getString(23)==null?"":lrst.getString(23));
					    result.setCorrDeudOtras(lrst.getString(24)==null?"":lrst.getString(24));
					    result.setCorrDeudEmp(lrst.getString(25)==null?"":lrst.getString(25));
					    result.setCorrProveed(lrst.getString(26)==null?"":lrst.getString(26));
					    result.setCorrOtrosAcreed(lrst.getString(27)==null?"":lrst.getString(27));
					    result.setCorrPeriodif(lrst.getString(28)==null?"":lrst.getString(28));
			        }
			        P06BLog.send(2,this, "Fin P06B52T00DAO-selectSumOfEjer");
			    } catch (SQLException e) {
			    	P06BLog.send(2,this, "error: " +e.getMessage());
		        	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			        //Propago la excepcin
			        throw e;
			    }catch (Exception e2) {	 
		        	P06BLog.send(2,this, "error: " +e2.getMessage());
		        	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			        //Propago la excepcin
			        throw e2;
			    }finally {
			    	try {
		        		if(lrst!=null)
		        			lrst.close();
		        	}catch (Exception rse) {}
			        try {
			        	if(lstm!=null)
			        		lstm.close();
			        }catch (Exception sse) {}
			        try {
			        	if(lconConexion!=null)
			        		lconConexion.close();
			        }catch (Exception cse) {}
			    }
				return result;
			}
			
			
	private static String SELECT_BY_PK =
		"SELECT " +	
		P06BTablas.P06B_P06B52_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B52_NUMEXP + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_CAPESCR + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_CAPNOEXIG + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_PRIMEMIS + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESER + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_ACCION + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJERANT + ", " +
		P06BTablas.P06B_P06B52_NETO_PROP_OTRASAPOR + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJER + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_DIVIDEN + ", " + 
		P06BTablas.P06B_P06B52_NETO_PROP_OTROSINSTR + ", " + 
		P06BTablas.P06B_P06B52_NETO_AJUSCAM + ", " + 
		P06BTablas.P06B_P06B52_NETO_SUBV + ", " +
		P06BTablas.P06B_P06B52_NOCORR_PROV + ", " + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_CRED + ", " +
		P06BTablas.P06B_P06B52_NOCORR_DEUD_ARREN + ", " + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_OTRAS + ", " + 
		P06BTablas.P06B_P06B52_NOCORR_DEUDEMP + ", " + 
		P06BTablas.P06B_P06B52_NOCORR_IMPUESDIF + ", " + 
		P06BTablas.P06B_P06B52_NOCORR_PERIODIF + ", " + 
		P06BTablas.P06B_P06B52_CORR_NOCORR + ", " + 
		P06BTablas.P06B_P06B52_CORR_PROV + ", " + 
		P06BTablas.P06B_P06B52_CORR_DEUD_CRED + ", " + 
		P06BTablas.P06B_P06B52_CORR_DEUD_ARREN + ", " + 
		P06BTablas.P06B_P06B52_CORR_DEUD_OTRAS + ", " + 
		P06BTablas.P06B_P06B52_CORR_DEUDEMP + ", " + 
		P06BTablas.P06B_P06B52_CORR_PROVEED + ", " + 
		P06BTablas.P06B_P06B52_CORR_OTROSACREED + ", " + 
		P06BTablas.P06B_P06B52_CORR_PERIODIF +
		
		" FROM "+ P06BTablas.P06B_P06B52T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B52_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B52_NUMEXP + " = ?";

	private static String SELECT_BY_PKTIPOMEDIADOR =
		"SELECT " + "SUM(" + 	
		P06BTablas.P06B_P06B52_NETO_PROP_CAPESCR + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_CAPNOEXIG + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_PRIMEMIS + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_RESER + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_ACCION + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJERANT + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_OTRASAPOR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJER + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_DIVIDEN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_OTROSINSTR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_AJUSCAM + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_SUBV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_PROV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_CRED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_ARREN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_OTRAS + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUDEMP + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_IMPUESDIF + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_PERIODIF + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_NOCORR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PROV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_CRED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_ARREN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_OTRAS + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUDEMP + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PROVEED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_OTROSACREED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PERIODIF + ") " + 		
		" FROM "+ P06BTablas.P06B_P06B52T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B52_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B52_NUMEXP + " LIKE ?";

	private static String SELECTSUM_OFEJER =
		"SELECT " + "SUM(" + 	
		P06BTablas.P06B_P06B52_NETO_PROP_CAPESCR + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_CAPNOEXIG + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_PRIMEMIS + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_RESER + "), " + "SUM(" +  
		P06BTablas.P06B_P06B52_NETO_PROP_ACCION + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJERANT + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_OTRASAPOR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_RESEJER + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_DIVIDEN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_PROP_OTROSINSTR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_AJUSCAM + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NETO_SUBV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_PROV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_CRED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_ARREN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUD_OTRAS + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_DEUDEMP + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_IMPUESDIF + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_NOCORR_PERIODIF + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_NOCORR + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PROV + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_CRED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_ARREN + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUD_OTRAS + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_DEUDEMP + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PROVEED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_OTROSACREED + "), " + "SUM(" + 
		P06BTablas.P06B_P06B52_CORR_PERIODIF + ") " + 		
		" FROM "+ P06BTablas.P06B_P06B52T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B52_EJERCICIO + " = ?";

}
